import numpy as np 
import matplotlib.pyplot as plt



def geo(ks, l, theta, v):
    return (1-l) ** ks * (theta/v - theta/(v * l)) + theta/(v * l)


ks = np.arange(10)
theta = 1
v = 1

for i, l in enumerate([0.9, 0.7, 0.4, 0.2]):
    tk = geo(ks, l, theta, v)
    plt.subplot(2,2,i + 1)
    plt.plot(ks, tk - tk[0])
    plt.legend([f'{l}'], loc='lower right')
#plt.show()
plt.savefig('simple.pdf')